CONTAINER fx_fluidsmoke
{
	NAME fx_fluidsmoke;
	INCLUDE Mpreview;
	INCLUDE Mbase;

	GROUP Obaselist
	{
		BOOL DPIT_MG_PRESETS {PAGE; HIDDEN;PARENTMSG DPIT_SMOKE_PRESETS_G;}
		BOOL DPIT_MG_GENERAL {PAGE; HIDDEN;PARENTMSG DPIT_GENERAL;}
		BOOL DPIT_MG_SHADOW {PAGE; HIDDEN;PARENTMSG DPIT_SMOKE_SELFSHADOW_G;}
		BOOL DPIT_MG_SMOKE {PAGE; HIDDEN;PARENTMSG DPIT_SMOKE_SMOKE_G;}
		BOOL DPIT_MG_HEAT {PAGE; HIDDEN;PARENTMSG DPIT_SMOKE_HEAT_G;}
		BOOL DPIT_MG_POSTWORK {PAGE; HIDDEN;PARENTMSG DPIT_SMOKE_POSTWORK_G;}
		BOOL DPIT_MG_DISPLAY {PAGE; HIDDEN;PARENTMSG DPIT_SMOKE_DISPLAY_TAB;}				
	}
	GROUP DPIT_SMOKE_PRESETS_G
	{
		LONG DPIT_SMOKE_PRESETS
		{
			CYCLE
			{
				DPIT_SMOKE_PRESET_DEFAULT;
			}
		}
		GROUP
		{
		COLUMNS 4;
		BUTTON DPIT_SMOKE_PRESETS_SET {}
		BUTTON DPIT_SMOKE_PRESETS_SAVE {}
		BUTTON DPIT_SMOKE_PRESETS_SAVEAS {}
		BUTTON DPIT_SMOKE_PRESETS_DE {}
		}
	}	
	GROUP DPIT_GENERAL
	{
		DEFAULT 1;		
		LINK  DPIT_SMOKE_SENSAI { ACCEPT{Obase;};}
		LONG  DPIT_SMOKE_LIGHTING
		{
			CYCLE
			{
			DPIT_SMOKE_LIGHTING_PHYSICAL;
			DPIT_SMOKE_SOLID;
			}
		}
		BOOL  DPIT_SMOKE_UNCLAMPED {}
		BOOL  DPIT_SMOKE_LIGHTMAPSAMPLER {}
		SEPARATOR {LINE;}

		BOOL  DPIT_SMOKE_RENDERTYPE {}
		BOOL  DPIT_HEAT_RENDERTYPE {}
		
		SEPARATOR {LINE;}

		LONG  DPIT_SMOKE_UPSAMPLING 
		{
			CYCLE
			{
				DPIT_SMOKE_UPSAMPLING_OFF;
				DPIT_SMOKE_UPSAMPLING_FIELDS;
			}
		}
		BOOL  DPIT_SMOKE_UPSAMPLING_PROPORTIONAL {PARENTID DPIT_SMOKE_UPSAMPLING;}
		VECTOR DPIT_SMOKE_UPSAMPLING_SIZE {MIN 1 1 1; MAX 1024 1024 1024; ANIM OFF; PARENTID DPIT_SMOKE_UPSAMPLING;}
		LONG DPIT_SMOKE_UPSAMPLING_INTERPOLATION 
		{
			CYCLE 
			{ 
				DPIT_SMOKE_UPSAMPLING_INTERPOLATION_LINEAR;
				DPIT_SMOKE_UPSAMPLING_INTERPOLATION_COSINE;
				DPIT_SMOKE_UPSAMPLING_INTERPOLATION_CUBIC;
			}
		}
		
		SEPARATOR {LINE;}

		BOOL  DPIT_SMOKE_EARLYRAYTERMINATION {}
		LONG DPIT_SMOKE_RENDER_INTERPOLATION 
		{
			CYCLE 
			{ 
				DPIT_SMOKE_RENDER_INTERPOLATION_LINEAR;
				DPIT_SMOKE_RENDER_INTERPOLATION_COSINE;
				DPIT_SMOKE_RENDER_INTERPOLATION_CUBIC;
			}
		}
		LONG  DPIT_SMOKE_STEPMAX {MIN 1; MAX 10000; HIDDEN;}
		REAL  DPIT_SMOKE_STEPHIT {MIN 0.01; MAX 1000; STEP 0.1;}
		REAL  DPIT_SMOKE_STEPSIZE {MIN 0.01; MAX 1000; STEP 0.1;}			
		REAL  DPIT_SMOKE_RAY_JITTER {MIN 0; MAX 100; UNIT PERCENT;}
		REAL  DPIT_SMOKE_GLADVECTION {MIN -1.0; MAX 1.0; STEP 0.001; }
		REAL  DPIT_SMOKE_GLADVECTION_FIRE {MIN -1.0; MAX 1.0; STEP 0.001; }
		LONG  DPIT_SMOKE_GLADVECTIONEXTENT {MIN 0; MAX 100;}
		SEPARATOR {LINE;}
			
		IN_EXCLUDE DPIT_SMOKE_LIGHTLIST
		{
			NUM_FLAGS 0; INIT_STATE 0; SEND_SELCHNGMSG 1;
			ACCEPT { Olight; };
		}
	}
	GROUP DPIT_SMOKE_SMOKE_G
	{
		REAL DPIT_SOLID_DIFFUSE { MIN 0; MAX 1000; UNIT PERCENT; MAXSLIDER 100; CUSTOMGUI REALSLIDER;}
		GROUP DPIT_SMOKE_COLOR_SID
		{
			DEFAULT 1;
			BOOL DPIT_SMOKE_COLOR_RGB {}
			LONG DPIT_SMOKE_DENSITYBASE
			{
				CYCLE
				{
				DPIT_SMOKE_DENSITYBASE_LOCALDENSITY;
				DPIT_SMOKE_DENSITYBASE_TOTALDENSITY;
				DPIT_SMOKE_DENSITYBASE_DEPTH;
				DPIT_SMOKE_DENSITYBASE_VELOCITY;
				DPIT_SMOKE_DENSITYBASE_OBJECT;
				DPIT_SMOKE_DENSITYBASE_VORTICITY;
				//DPIT_SMOKE_DENSITYBASE_GRADIENT;
				}
			}
			REAL	DPIT_SMOKE_DENSITYBASE_MULTIFIELD {MIN 0.0; UNIT METER;}
			LINK	DPIT_SMOKE_DENSITYBASE_OBJECTLINK {ACCEPT{Obase;};}
			GRADIENT DPIT_SMOKE_COLOR {COLOR; ANIM ON;}
			COLOR	DPIT_SMOKE_AMBIENT {}				
		}

		GROUP DPIT_SMOKE_DENSITY_SID
		{
			DEFAULT 1;
			LONG	DPIT_SMOKE_DENSITY_FIELD
			{
				CYCLE
				{
					DPIT_SMOKE_DENSITY_FIELD_SMOKE;
					DPIT_SMOKE_DENSITY_FIELD_TEMP;
					DPIT_SMOKE_DENSITY_FIELD_FIRE;
					DPIT_SMOKE_DENSITY_FIELD_FUEL;
					DPIT_SMOKE_DENSITY_FIELD_COLOR;
					DPIT_SMOKE_DENSITY_FIELD_PARTICLESMOKE;
					DPIT_SMOKE_DENSITY_FIELD_PARTICLETEMP;
					DPIT_SMOKE_DENSITY_FIELD_PARTICLEFIRE;
					DPIT_SMOKE_DENSITY_FIELD_PARTICLEFUEL;
				}
			}
			REAL	DPIT_SMOKE_THRESHOLD {MIN 0; MAX 0.999; STEP 0.001;}
			REAL	DPIT_SMOKE_BASEDENSITY {MIN 0; UNIT PERCENT;}
			GRADIENT DPIT_SMOKE_DENSITY_FALLOFF {ALPHA; ANIM ON;}

			SEPARATOR {LINE;}
			
			LONG  DPIT_SMOKE_DENSITY_BLURITER {MIN 0; MAX 100;}
			REAL  DPIT_SMOKE_DENSITY_BLUR {MIN 0; MAX 1000;}
			
			GROUP DPIT_SMOKE_PARTICLESUBTAB
			{
				DEFAULT 1;
				REAL	DPIT_SMOKE_PARTICLEDENSITY {MIN 0; UNIT PERCENT;}
				BOOL DPIT_SMOKE_PARTICLE_USEAGE {}
				GRADIENT DPIT_SMOKE_PARTICLE_AGEGRADIENT {ANIM ON; ALPHA;}
				
				SEPARATOR {LINE;}

				LONG	DPIT_SMOKE_PARTICLERADIMODE
				{
					CYCLE { DPIT_SMOKE_PARTICLERADIMODE_ORIG; DPIT_SMOKE_PARTICLERADIMODE_CUSTOM; }
				}
				REAL	DPIT_SMOKE_PARTICLE_CUSTOMRAD {MIN 1; UNIT METER;}
				REAL	DPIT_SMOKE_PARTICLE_CUSTOMRADVAR {MIN 0; MAX 100; UNIT PERCENT;}
				
				SEPARATOR {LINE;}

				LONG	DPIT_SMOKE_PARTICLE_FALLOFFMODE
				{
					CYCLE {DPIT_SMOKE_PARTICLE_FALLOFFMODE_CONST; DPIT_SMOKE_PARTICLE_FALLOFFMODE_LINEAR; DPIT_SMOKE_PARTICLE_FALLOFFMODE_CUSTOM; } 
				}
				GRADIENT DPIT_SMOKE_PARTICLE_FALLOFFGRADIENT {ANIM ON; ALPHA;}
				BOOL	DPIT_SMOKE_PARTICLE_NOISE {}
				GROUP
				{			
					LONG DPIT_PARTICLESMOKE_NOISE
					{
					     CYCLE
					      {
						      
							DPIT_PARTICLESMOKE_NOISE_BOX_NOISE;
							DPIT_PARTICLESMOKE_NOISE_BLIST_TURB;
							DPIT_PARTICLESMOKE_NOISE_BUYA;
							DPIT_PARTICLESMOKE_NOISE_CELL_NOISE;
							DPIT_PARTICLESMOKE_NOISE_CRANAL;
							DPIT_PARTICLESMOKE_NOISE_DENTS;
							DPIT_PARTICLESMOKE_NOISE_DISPL_TURB;
							DPIT_PARTICLESMOKE_NOISE_FBM;
							DPIT_PARTICLESMOKE_NOISE_HAMA;
							DPIT_PARTICLESMOKE_NOISE_LUKA;
							DPIT_PARTICLESMOKE_NOISE_MOD_NOISE;
							DPIT_PARTICLESMOKE_NOISE_NAKI;
							DPIT_PARTICLESMOKE_NOISE_NOISE;
							DPIT_PARTICLESMOKE_NOISE_NUTOUS;
							DPIT_PARTICLESMOKE_NOISE_OBER;
							DPIT_PARTICLESMOKE_NOISE_PEZO;
							DPIT_PARTICLESMOKE_NOISE_POXO;
							DPIT_PARTICLESMOKE_NOISE_RANDOM;
							DPIT_PARTICLESMOKE_NOISE_SEMA;
							DPIT_PARTICLESMOKE_NOISE_STUPL;
							DPIT_PARTICLESMOKE_NOISE_TURBULENCE;
							DPIT_PARTICLESMOKE_NOISE_VL_NOISE;
							DPIT_PARTICLESMOKE_NOISE_WAVY_TURB;
							DPIT_PARTICLESMOKE_NOISE_SEPARATOR;
							DPIT_PARTICLESMOKE_NOISE_CELL_VORONOI;
							DPIT_PARTICLESMOKE_NOISE_DISPL_VORONOI;
							DPIT_PARTICLESMOKE_NOISE_SPARSE_CONV;
							DPIT_PARTICLESMOKE_NOISE_VORONOI_1;
							DPIT_PARTICLESMOKE_NOISE_VORONOI_2;
							DPIT_PARTICLESMOKE_NOISE_VORONOI_3;
							DPIT_PARTICLESMOKE_NOISE_ZADA;
							DPIT_PARTICLESMOKE_NOISE_FIRE;
							DPIT_PARTICLESMOKE_NOISE_ELECTRIC;
							DPIT_PARTICLESMOKE_NOISE_GASOUS;
						}
					}
					REAL DPIT_PARTICLESMOKE_NOISE_DENSITY {MIN 0; MAX 1000; UNIT PERCENT;}	
					GRADIENT DPIT_PARTICLESMOKE_GRADIENT {ANIM ON; ALPHA;}
					REAL DPIT_PARTICLESMOKE_NOISE_SCAGBL {MIN 0; UNIT PERCENT;}
					VECTOR DPIT_PARTICLESMOKE_NOISE_SCALE {MIN 0 0 0; UNIT PERCENT;}
					LONG DPIT_PARTICLESMOKE_NOISE_OCTAVES {MIN 0; MAX 20;}
					REAL DPIT_PARTICLESMOKE_NOISE_SPEED {STEP 0.1;}
					BOOL DPIT_PARTICLESMOKE_NOISE_ABS {}
				}
			}
		}
		GROUP DPIT_SMOKE_OPTICAL_SID
		{		
			LONG  DPIT_SMOKE_INTEGRATION
			{
				CYCLE
				{
					//DPIT_SMOKE_INTEGRATION_EXTINCTION;
					DPIT_SMOKE_INTEGRATION_ABSORPTION;
					DPIT_SMOKE_INTEGRATION_ALBEDO;
					DPIT_SMOKE_INTEGRATION_CUSTOM;
				}
			}
			LONG  DPIT_SMOKE_INTEGRATION_MODE
			{
				CYCLE
				{
					DPIT_SMOKE_INTEGRATION_MODE_ADD;
					DPIT_SMOKE_INTEGRATION_MODE_MULTIPLY;
				}
			}
			REAL  DPIT_SMOKE_OPACITY {MIN 0; MAX 100; UNIT PERCENT; CUSTOMGUI REALSLIDER; }	
			REAL  DPIT_SMOKE_DECAY {MIN 0; MAX 1000; MAXSLIDER 100;UNIT PERCENT;CUSTOMGUI REALSLIDER;}
			REAL  DPIT_SMOKE_ALBEDO {MIN 0; MAX 1000; MAXSLIDER 100;UNIT PERCENT;CUSTOMGUI REALSLIDER;}
			LONG  DPIT_SMOKE_PHASE
			{
				CYCLE
				{
					SMOKE_PHASE_NONE;
					SMOKE_PHASE_GREENSTEIN;
					SMOKE_PHASE_RAYLEIGH;
					SMOKE_PHASE_MIE;
					SMOKE_PHASE_HAZY;
					SMOKE_PHASE_MURKY;
					SMOKE_PHASE_SCHLICK;
				}
			}
			REAL DPIT_SMOKE_GREENSTEIN_G {MIN -100; MAX 100; UNIT PERCENT;}
			REAL DPIT_SMOKE_PHASEINTENSITY {MIN 0; MAX 1000; MAXSLIDER 100;UNIT PERCENT;CUSTOMGUI REALSLIDER;}
			
			GROUP DPIT_SMOKE_MS_SID
			{
				BOOL  DPIT_SMOKE_USEMS {}
				BOOL  DPIT_SMOKE_MS_HOMOGEN {}
				LONG  DPIT_SMOKE_MS_MAPSIZE
				{
					CYCLE
					{
						DPIT_SMOKE_MS_MAPSIZE_SIM;
						DPIT_SMOKE_MS_MAPSIZE_64;
						DPIT_SMOKE_MS_MAPSIZE_128;
						DPIT_SMOKE_MS_MAPSIZE_256;						
						DPIT_SMOKE_MS_MAPSIZE_CUSTOM;
					}
					HIDDEN;
				}
				LONG  DPIT_SMOKE_MS_CUSTOMSIZE { MIN 32; HIDDEN;}

				REAL  DPIT_SMOKE_MS_SPACESCALE { MIN 0.01; MAX 100; UNIT PERCENT;}
				REAL  DPIT_SMOKE_MS_INTENSITY {MIN 0; MAX 10000; UNIT PERCENT;}
				REAL  DPIT_SMOKE_MS_ABSORPTION {MIN 0; MAX 10000; UNIT PERCENT; STEP 0.001;}
				REAL  DPIT_SMOKE_MS_SCATTERING { MIN 0.001; MAX 6.0; STEP 0.01;}
				REAL  DPIT_SMOKE_MS_MSA { MIN 0; MAX 180; UNIT DEGREE;}

				SEPARATOR {LINE;}

				REAL  DPIT_SMOKE_MS_MINCONTRIBUTION {MIN 0; MAX 10; STEP 0.001; UNIT PERCENT;}
				REAL  DPIT_SMOKE_MS_STEPSIZE {MIN 0.01; MAX 1000; STEP 0.1; PARENTID DPIT_SMOKE_INDECAY;}
				REAL  DPIT_SMOKE_MS_DIFFUSION {MIN 1; MAX 1000; STEP 0.1;}
			}	
		}
		GROUP DPIT_SMOKE_SELFSHADOW_SID
		{
			GROUP
			{
				COLUMNS 2;
				REAL  DPIT_SMOKE_INDECAY {MIN 0; MAX 10000; UNIT PERCENT;}
				REAL  DPIT_SMOKE_SHADE_JITTER {MIN 0; MAX 100; UNIT PERCENT; PARENTID DPIT_SMOKE_INDECAY;}
				REAL  DPIT_SMOKE_STEPHIT_SHADE {MIN 0.01; MAX 1000; STEP 0.1;}
				REAL  DPIT_SMOKE_STEPSIZE_SHADE {MIN 0.01; MAX 1000; STEP 0.1; PARENTID DPIT_SMOKE_INDECAY;}
				COLOR  DPIT_SMOKE_SELFSHADOW_COLOR {}
			}
			GROUP DPIT_SMOKE_SHADINGMAP_SID
			{
				BOOL  DPIT_SMOKE_SHADINGMAP {}
				BOOL  DPIT_SMOKE_SHADINGMAP_CUSTOMSIZE {}
				BOOL  DPIT_SMOKE_SHADINGMAP_PROPORTIONAL {PARENTID DPIT_SMOKE_SHADINGMAP_CUSTOMSIZE;}
				VECTOR DPIT_SMOKE_SHADINGMAP_SIZE {MIN 1 1 1; ANIM OFF; PARENTID DPIT_SMOKE_SHADINGMAP_CUSTOMSIZE;}

				SEPARATOR {LINE;}

				LONG  DPIT_SMOKE_SHADINGMAP_BLURITER {MIN 0; MAX 100;}
				REAL  DPIT_SMOKE_SHADINGMAP_BLUR {MIN 0; MAX 1000;}
				LONG  DPIT_SMOKE_SHADINGMAP_BLURBLENDING 
				{
					CYCLE
					{
					DPIT_SMOKE_SHADINGMAP_BLURBLENDING_NORMAL;
					DPIT_SMOKE_SHADINGMAP_BLURBLENDING_MULTIPLY;
					DPIT_SMOKE_SHADINGMAP_BLURBLENDING_DARKEN;
					DPIT_SMOKE_SHADINGMAP_BLURBLENDING_LIGHTEN;
					DPIT_SMOKE_SHADINGMAP_BLURBLENDING_SCREEN;
					DPIT_SMOKE_SHADINGMAP_BLURBLENDING_OVERLAY;
					DPIT_SMOKE_SHADINGMAP_BLURBLENDING_HARDLIGHT;
					DPIT_SMOKE_SHADINGMAP_BLURBLENDING_SOFTLIGHT;
					
					MENU_SEPARATOR;

					DPIT_SMOKE_SHADINGMAP_BLURBLENDING_COLORDODGE;
					DPIT_SMOKE_SHADINGMAP_BLURBLENDING_INVCOLORDODGE;
					DPIT_SMOKE_SHADINGMAP_BLURBLENDING_COLORBURN;
					DPIT_SMOKE_SHADINGMAP_BLURBLENDING_SOFTBURN;

					MENU_SEPARATOR;

					DPIT_SMOKE_SHADINGMAP_BLURBLENDING_DIFFERENCE;
					DPIT_SMOKE_SHADINGMAP_BLURBLENDING_NDIFFERENCE;
					DPIT_SMOKE_SHADINGMAP_BLURBLENDING_EXCLUDE;
					DPIT_SMOKE_SHADINGMAP_BLURBLENDING_REFLECT;
					DPIT_SMOKE_SHADINGMAP_BLURBLENDING_ADD;
					DPIT_SMOKE_SHADINGMAP_BLURBLENDING_SUB;
					}
				}
				REAL  DPIT_SMOKE_SHADINGMAP_BLURBLENDMIX {MIN 0; MAX 1000; UNIT PERCENT;}
				SEPARATOR {LINE;}
				BOOL  DPIT_SMOKE_SHADINGMAP_REMAP {}
				GRADIENT DPIT_SMOKE_SHADINGMAP_REMAPGRAD {ANIM ON; ALPHA;}
				REAL  DPIT_SMOKE_SHADINGMAP_REMAPMUL {MIN 0; UNIT PERCENT;}
			}	
		}		
		GROUP DPIT_SMOKE_SPECULAR_G
		{				
			COLOR DPIT_SMOKE_SPECCOLOR {}
			REAL DPIT_SMOKE_SPECWIDTH {MIN 0; MAX 100; UNIT PERCENT;CUSTOMGUI REALSLIDER;}
			REAL DPIT_SMOKE_SPECHEIGHT {MIN 0; MAX 1000; MAXSLIDER 100; UNIT PERCENT;CUSTOMGUI REALSLIDER;}
			REAL DPIT_SMOKE_SPECFALLOFF {MIN 0; MAX 100; UNIT PERCENT;CUSTOMGUI REALSLIDER;}
			REAL DPIT_SMOKE_SPECINNERWIDTH {MIN 0; MAX 100; UNIT PERCENT;CUSTOMGUI REALSLIDER;}
			//BOOL DPIT_SMOKE_SPECINVERT {MIN -100; MAX 100; MAXSLIDER 100; MINSLIDER -100;}
			
		}
		GROUP DPIT_SMOKE_REFLECTION_G
		{		
			REAL DPIT_SMOKE_REFLECTION {MIN 0; MAX 1000; MAXSLIDER 100; UNIT PERCENT; CUSTOMGUI REALSLIDER;}
			REAL DPIT_SMOKE_REFLFRESNEL {MIN 0; MAX 100; UNIT PERCENT; CUSTOMGUI REALSLIDER;}
			BOOL DPIT_SMOKE_REFLFRESNEL_INV {} //Invert the fresnel term
		}
		GROUP DPIT_SMOKE_FRESNEL_G
		{
			LONG DPIT_SMOKE_FRESNELTYPE
			{
				CYCLE
				{
					DPIT_SMOKE_NOFRESNEL;
					DPIT_SMOKE_SIMPLEFRESNEL;
					DPIT_SMOKE_SCHLICKFRESNEL;
					DPIT_SMOKE_COMPLEXFRESNEL;
				}
			}
			BOOL DPIT_SMOKE_GLOBALFRESNEL {}
			REAL DPIT_SMOKE_FRESNEL {MIN 0; MAX 300; MAXSLIDER 100; UNIT PERCENT; CUSTOMGUI REALSLIDER;}
			REAL DPIT_SMOKE_FRES_REFRINDEX {MIN 0.01; MAX 1000; STEP 0.1;}
			GRADIENT DPIT_SMOKE_FRESNEL_FALLOFF {ALPHA; ANIM ON;}		
		}
		GROUP DPIT_SMOKE_SHADOWS_SID
		{			
			BOOL DPIT_SMOKE_GETSHADOW {}
			BOOL DPIT_SMOKE_CASTSHADOW {}
			REAL DPIT_SMOKE_CASTSHADOWSTEPSIZE {MIN 0.001; PARENTID DPIT_SMOKE_CASTSHADOW;}
			REAL DPIT_SMOKE_CASTSHADOWINTENSITY {MIN 0; MAX 500; UNIT PERCENT; PARENTID DPIT_SMOKE_CASTSHADOW;}
			LONG DPIT_SMOKE_SHADOWMODE
			{
				PARENTID DPIT_SMOKE_CASTSHADOW;
				CYCLE
				{
					DPIT_SMOKE_SHADOWPHYSICAL;
					DPIT_SMOKE_SHADOWARTISTIC;
					DPIT_SMOKE_SHADOWMATERIAL;
					//DPIT_SMOKE_SHADOWSOLID;
				}
			}
			SEPARATOR {LINE;}
			BOOL DPIT_SMOKE_LIGHTSHADOWCOLOR {PARENTID DPIT_SMOKE_CASTSHADOW;}
			COLOR DPIT_SMOKE_SHADOWCOLOR {PARENTID DPIT_SMOKE_CASTSHADOW;}
		}
		GROUP DPIT_SMOKE_ALPHA_G
		{
			BOOL DPIT_SMOKE_USENOISE {}
			GROUP
			{			
				LAYOUTGROUP; COLUMNS 2;
				GROUP
				{
					BITMAPBUTTON DPIT_SMOKE_NOISE_PREVIEW {BORDER;}
				}
				GROUP
				{
					LONG DPIT_SMOKE_NOISE
					{
					     CYCLE
					      {
					      
							DPIT_SMOKE_NOISE_BOX_NOISE;
							DPIT_SMOKE_NOISE_BLIST_TURB;
							DPIT_SMOKE_NOISE_BUYA;
							DPIT_SMOKE_NOISE_CELL_NOISE;
							DPIT_SMOKE_NOISE_CRANAL;
							DPIT_SMOKE_NOISE_DENTS;
							DPIT_SMOKE_NOISE_DISPL_TURB;
							DPIT_SMOKE_NOISE_FBM;
							DPIT_SMOKE_NOISE_HAMA;
							DPIT_SMOKE_NOISE_LUKA;
							DPIT_SMOKE_NOISE_MOD_NOISE;
							DPIT_SMOKE_NOISE_NAKI;
							DPIT_SMOKE_NOISE_NOISE;
							DPIT_SMOKE_NOISE_NUTOUS;
							DPIT_SMOKE_NOISE_OBER;
							DPIT_SMOKE_NOISE_PEZO;
							DPIT_SMOKE_NOISE_POXO;
							DPIT_SMOKE_NOISE_RANDOM;
							DPIT_SMOKE_NOISE_SEMA;
							DPIT_SMOKE_NOISE_STUPL;
							DPIT_SMOKE_NOISE_TURBULENCE;
							DPIT_SMOKE_NOISE_VL_NOISE;
							DPIT_SMOKE_NOISE_WAVY_TURB;
							DPIT_SMOKE_NOISE_SEPARATOR;
							DPIT_SMOKE_NOISE_CELL_VORONOI;
							DPIT_SMOKE_NOISE_DISPL_VORONOI;
							DPIT_SMOKE_NOISE_SPARSE_CONV;
							DPIT_SMOKE_NOISE_VORONOI_1;
							DPIT_SMOKE_NOISE_VORONOI_2;
							DPIT_SMOKE_NOISE_VORONOI_3;
							DPIT_SMOKE_NOISE_ZADA;
							DPIT_SMOKE_NOISE_FIRE;
							DPIT_SMOKE_NOISE_ELECTRIC;
							DPIT_SMOKE_NOISE_GASOUS;
						}
					}
					LONG DPIT_SMOKE_NOISE_BASE
					{
						CYCLE
						{
							DPIT_SMOKE_NOISE_BASE_WORLD;
							DPIT_SMOKE_NOISE_BASE_FLOW;
						}
					}
					LONG DPIT_SMOKE_NOISE_DENSITY_BASE
					{
						CYCLE
						{
							DPIT_SMOKE_NOISE_DENSITY_BASE_CUSTOM;
							DPIT_SMOKE_NOISE_DENSITY_BASE_MAGNITUDE;
							DPIT_SMOKE_NOISE_DENSITY_BASE_SMOKE;
							DPIT_SMOKE_NOISE_DENSITY_BASE_HEAT;
							DPIT_SMOKE_NOISE_DENSITY_BASE_FIRE;
							DPIT_SMOKE_NOISE_DENSITY_BASE_VORTICITY;
						}
					}
					REAL DPIT_SMOKE_NOISE_DENSITY_BASE_FIELD {MIN 0.001; }
					REAL DPIT_SMOKE_NOISE_DENSITY {MIN 0; MAX 1000; UNIT PERCENT;}
				}
			}		
			SEPARATOR{LINE;}	
			GRADIENT DPIT_SMOKE_NOISE_GRADIENT {ALPHA; ANIM ON;}

			GROUP DPIT_SMOKE_NOISE_SID
			{
				REAL DPIT_SMOKE_NOISE_SCAGBL {MIN 0.001; UNIT PERCENT;}
				VECTOR DPIT_SMOKE_NOISE_SCALE {MIN 0.001 0.001 0.001; UNIT PERCENT;}
				LONG DPIT_SMOKE_NOISE_OCTAVES {MIN 0; MAX 20;}
				REAL DPIT_SMOKE_NOISE_SPEED {STEP 0.1;}
				BOOL DPIT_SMOKE_NOISE_ABS {}
			}
		}
	}
	GROUP DPIT_SMOKE_HEAT_G
	{		
		LONG  DPIT_HEAT_CHANNEL_DETECTION
		{
			CYCLE
			{
				DPIT_HEAT_CHANNEL_DETECTION_HEAT;
				DPIT_HEAT_CHANNEL_DETECTION_BURN;
			}
		}
		BOOL DPIT_HEAT_COLORSMOKE_ONLY {}
		GROUP DPIT_HEAT_COLOR_SID
		{
			DEFAULT 1;
			LONG DPIT_SMOKE_HEATBASE
			{
				CYCLE
				{
				DPIT_SMOKE_HEATBASE_PHYSICAL;
				DPIT_SMOKE_HEATBASE_LOCALDENSITY;
				DPIT_SMOKE_HEATBASE_TOTALDENSITY;
				DPIT_SMOKE_HEATBASE_DEPTH;
				DPIT_SMOKE_HEATBASE_VELOCITY;
				DPIT_SMOKE_HEATBASE_OBJECT;
				DPIT_SMOKE_HEATBASE_VORTICITY;
				}
			}
			REAL	DPIT_SMOKE_HEATBASE_MULTIFIELD {MIN 0.0; UNIT METER;}
			LINK	DPIT_SMOKE_HEATBASE_OBJECTLINK {ACCEPT{Obase;};}
			GRADIENT DPIT_SMOKE_HEATCOLOR {COLOR; ANIM ON;}

			//Physical Fire Color
			BITMAPBUTTON DPIT_SMOKE_HEATPLANCK {BORDER;} //Show physical gradient
			LONG DPIT_SMOKE_HEATPLANCK_CLAMP 
			{
				CYCLE
				{
					DPIT_SMOKE_HEATPLANCK_CLAMP_NTSC;
					DPIT_SMOKE_HEATPLANCK_CLAMP_PAL;
					DPIT_SMOKE_HEATPLANCK_CLAMP_SMPTE;
					DPIT_SMOKE_HEATPLANCK_CLAMP_HDTV;
					DPIT_SMOKE_HEATPLANCK_CLAMP_CIE;
					DPIT_SMOKE_HEATPLANCK_CLAMP_CIEREC709;
				}
			}
			VECTOR DPIT_SMOKE_HEATPLANCK_BOOST {MIN 0 0 0; MAX 100 100 100; STEP 0.01;}
			REAL DPIT_SMOKE_FIRELIGHT_INTENSITY {MIN 1; MAX 10; STEP 0.01; }
			REAL DPIT_SMOKE_HEATPLANCK_SCALE {MIN 0; MAX 100; STEP 0.1; CUSTOMGUI REALSLIDER;}

			SEPARATOR{LINE;}
			REAL DPIT_HEAT_AFFECTGI  {MIN 0; MAX 10000; UNIT PERCENT; }
			SEPARATOR{LINE;}

			REAL DPIT_HEAT_AFFECTSMOKE  {MIN 0; MAX 10000; STEP 0.1; }
			VECTOR DPIT_HEAT_AFFECTSMOKE_DIM {MIN 10 10 10; STEP 1;}
			VECTOR DPIT_HEAT_AFFECTSMOKE_DIM_RENDER {MIN 10 10 10; STEP 1;}
			REAL DPIT_HEAT_AFFECTSMOKE_TSCALE {MIN 1; MAX 100; STEP 0.01; }
			REAL DPIT_HEAT_AFFECTSMOKE_RADIUS {MIN 1; UNIT METER;}
			LONG DPIT_HEAT_SMOKELIGHT_TYPE 
			{
				CYCLE
				{
					DPIT_HEAT_SMOKELIGHT_TYPE_PHYSICAL;
					DPIT_HEAT_SMOKELIGHT_TYPE_CUSTOM;
				}
			}
			GRADIENT DPIT_HEAT_CUSTOMSMOKELIGHTING {COLOR; ANIM ON;}
		}
		GROUP DPIT_HEAT_DENSITY_SID
		{
			DEFAULT 1;			
			LONG	DPIT_HEAT_DENSITY_FIELD
			{
				CYCLE
				{
					DPIT_HEAT_DENSITY_FIELD_SMOKE;
					DPIT_HEAT_DENSITY_FIELD_TEMP;
					DPIT_HEAT_DENSITY_FIELD_FIRE;
					DPIT_HEAT_DENSITY_FIELD_FUEL;
					DPIT_HEAT_DENSITY_FIELD_PARTICLESMOKE;
					DPIT_HEAT_DENSITY_FIELD_PARTICLETEMP;
					DPIT_HEAT_DENSITY_FIELD_PARTICLEFIRE;
					DPIT_HEAT_DENSITY_FIELD_PARTICLEFUEL;
				}
			}
			REAL	DPIT_HEAT_THRESHOLD {MIN 297.5; MAX 5000; STEP 1;}		
			GRADIENT DPIT_HEAT_DENSITY_FALLOFF {ALPHA; ANIM ON;}
			SEPARATOR {LINE;}
			
			LONG  DPIT_HEAT_DENSITY_BLURITER {MIN 0; MAX 100;}
			REAL  DPIT_HEAT_DENSITY_BLUR {MIN 0; MAX 1000;}
			
			GROUP DPIT_HEAT_PARTICLESUBTAB
			{
				REAL	DPIT_HEAT_PARTICLEDENSITY {MIN 0; UNIT PERCENT;}
				BOOL DPIT_HEAT_PARTICLE_USEAGE {}
				GRADIENT DPIT_HEAT_PARTICLE_AGEGRADIENT {ANIM ON; ALPHA;}
				
				SEPARATOR {LINE;}

				LONG	DPIT_HEAT_PARTICLERADIMODE
				{
					CYCLE { DPIT_HEAT_PARTICLERADIMODE_ORIG; DPIT_HEAT_PARTICLERADIMODE_CUSTOM; }
				}
				REAL	DPIT_HEAT_PARTICLE_CUSTOMRAD {MIN 1; UNIT METER;}
				REAL	DPIT_HEAT_PARTICLE_CUSTOMRADVAR {MIN 0; MAX 100; UNIT PERCENT;}
				
				SEPARATOR {LINE;}

				LONG	DPIT_HEAT_PARTICLE_FALLOFFMODE
				{
					CYCLE {DPIT_HEAT_PARTICLE_FALLOFFMODE_CONST; DPIT_HEAT_PARTICLE_FALLOFFMODE_LINEAR; DPIT_HEAT_PARTICLE_FALLOFFMODE_CUSTOM; } 
				}
				GRADIENT DPIT_HEAT_PARTICLE_FALLOFFGRADIENT {ANIM ON; ALPHA;}
				BOOL	DPIT_HEAT_PARTICLE_NOISE {}
				GROUP
				{			
					LONG DPIT_PARTICLEHEAT_NOISE
					{
					     CYCLE
					      {
						      
							DPIT_PARTICLEHEAT_NOISE_BOX_NOISE;
							DPIT_PARTICLEHEAT_NOISE_BLIST_TURB;
							DPIT_PARTICLEHEAT_NOISE_BUYA;
							DPIT_PARTICLEHEAT_NOISE_CELL_NOISE;
							DPIT_PARTICLEHEAT_NOISE_CRANAL;
							DPIT_PARTICLEHEAT_NOISE_DENTS;
							DPIT_PARTICLEHEAT_NOISE_DISPL_TURB;
							DPIT_PARTICLEHEAT_NOISE_FBM;
							DPIT_PARTICLEHEAT_NOISE_HAMA;
							DPIT_PARTICLEHEAT_NOISE_LUKA;
							DPIT_PARTICLEHEAT_NOISE_MOD_NOISE;
							DPIT_PARTICLEHEAT_NOISE_NAKI;
							DPIT_PARTICLEHEAT_NOISE_NOISE;
							DPIT_PARTICLEHEAT_NOISE_NUTOUS;
							DPIT_PARTICLEHEAT_NOISE_OBER;
							DPIT_PARTICLEHEAT_NOISE_PEZO;
							DPIT_PARTICLEHEAT_NOISE_POXO;
							DPIT_PARTICLEHEAT_NOISE_RANDOM;
							DPIT_PARTICLEHEAT_NOISE_SEMA;
							DPIT_PARTICLEHEAT_NOISE_STUPL;
							DPIT_PARTICLEHEAT_NOISE_TURBULENCE;
							DPIT_PARTICLEHEAT_NOISE_VL_NOISE;
							DPIT_PARTICLEHEAT_NOISE_WAVY_TURB;
							DPIT_PARTICLEHEAT_NOISE_SEPARATOR;
							DPIT_PARTICLEHEAT_NOISE_CELL_VORONOI;
							DPIT_PARTICLEHEAT_NOISE_DISPL_VORONOI;
							DPIT_PARTICLEHEAT_NOISE_SPARSE_CONV;
							DPIT_PARTICLEHEAT_NOISE_VORONOI_1;
							DPIT_PARTICLEHEAT_NOISE_VORONOI_2;
							DPIT_PARTICLEHEAT_NOISE_VORONOI_3;
							DPIT_PARTICLEHEAT_NOISE_ZADA;
							DPIT_PARTICLEHEAT_NOISE_FIRE;
							DPIT_PARTICLEHEAT_NOISE_ELECTRIC;
							DPIT_PARTICLEHEAT_NOISE_GASOUS;
						}
					}
					REAL DPIT_PARTICLEHEAT_NOISE_DENSITY {MIN 0; MAX 1000; UNIT PERCENT;}	
					GRADIENT DPIT_PARTICLEHEAT_GRADIENT {ANIM ON; ALPHA;}
					REAL DPIT_PARTICLEHEAT_NOISE_SCAGBL {MIN 0; UNIT PERCENT;}
					VECTOR DPIT_PARTICLEHEAT_NOISE_SCALE {MIN 0 0 0; UNIT PERCENT;}
					LONG DPIT_PARTICLEHEAT_NOISE_OCTAVES {MIN 0; MAX 20;}
					REAL DPIT_PARTICLEHEAT_NOISE_SPEED {STEP 0.1;}
					BOOL DPIT_PARTICLEHEAT_NOISE_ABS {}
				}
			}
		}
		GROUP DPIT_HEAT_FIREDENSITY_SID
		{
			DEFAULT 1;
			
			LONG	DPIT_FIRE_DENSITY_FIELD
			{
				CYCLE
				{
					DPIT_FIRE_DENSITY_FIELD_SMOKE;
					DPIT_FIRE_DENSITY_FIELD_TEMP;
					DPIT_FIRE_DENSITY_FIELD_FIRE;
					DPIT_FIRE_DENSITY_FIELD_FUEL;
					DPIT_FIRE_DENSITY_FIELD_PARTICLESMOKE;
					DPIT_FIRE_DENSITY_FIELD_PARTICLETEMP;
					DPIT_FIRE_DENSITY_FIELD_PARTICLEFIRE;
					DPIT_FIRE_DENSITY_FIELD_PARTICLEFUEL;
				}
			}
			REAL	DPIT_HEAT_BURN_THRESHOLD {MIN 0; MAX 0.999; STEP 0.001;}		
			GRADIENT DPIT_HEAT_BURN_DENSITY_FALLOFF {ALPHA; ANIM ON;}
			SEPARATOR {LINE;}
			
			LONG  DPIT_FIRE_DENSITY_BLURITER {MIN 0; MAX 100;}
			REAL  DPIT_FIRE_DENSITY_BLUR {MIN 0; MAX 1000;}
			
			GROUP DPIT_FIRE_PARTICLESUBTAB
			{
				REAL	DPIT_FIRE_PARTICLEDENSITY {MIN 0; UNIT PERCENT;}
				BOOL DPIT_FIRE_PARTICLE_USEAGE {}
				GRADIENT DPIT_FIRE_PARTICLE_AGEGRADIENT {ANIM ON; ALPHA;}
				
				SEPARATOR {LINE;}

				LONG	DPIT_FIRE_PARTICLERADIMODE
				{
					CYCLE { DPIT_FIRE_PARTICLERADIMODE_ORIG; DPIT_FIRE_PARTICLERADIMODE_CUSTOM; }
				}
				REAL	DPIT_FIRE_PARTICLE_CUSTOMRAD {MIN 1; UNIT METER;}
				REAL	DPIT_FIRE_PARTICLE_CUSTOMRADVAR {MIN 0; MAX 100; UNIT PERCENT;}
				
				SEPARATOR {LINE;}

				LONG	DPIT_FIRE_PARTICLE_FALLOFFMODE
				{
					CYCLE {DPIT_FIRE_PARTICLE_FALLOFFMODE_CONST; DPIT_FIRE_PARTICLE_FALLOFFMODE_LINEAR; DPIT_FIRE_PARTICLE_FALLOFFMODE_CUSTOM; } 
				}
				GRADIENT DPIT_FIRE_PARTICLE_FALLOFFGRADIENT {ANIM ON; ALPHA;}
				BOOL	DPIT_FIRE_PARTICLE_NOISE {}
				GROUP
				{			
					LONG DPIT_PARTICLEFIRE_NOISE
					{
					     CYCLE
					      {
						      
							DPIT_PARTICLEFIRE_NOISE_BOX_NOISE;
							DPIT_PARTICLEFIRE_NOISE_BLIST_TURB;
							DPIT_PARTICLEFIRE_NOISE_BUYA;
							DPIT_PARTICLEFIRE_NOISE_CELL_NOISE;
							DPIT_PARTICLEFIRE_NOISE_CRANAL;
							DPIT_PARTICLEFIRE_NOISE_DENTS;
							DPIT_PARTICLEFIRE_NOISE_DISPL_TURB;
							DPIT_PARTICLEFIRE_NOISE_FBM;
							DPIT_PARTICLEFIRE_NOISE_HAMA;
							DPIT_PARTICLEFIRE_NOISE_LUKA;
							DPIT_PARTICLEFIRE_NOISE_MOD_NOISE;
							DPIT_PARTICLEFIRE_NOISE_NAKI;
							DPIT_PARTICLEFIRE_NOISE_NOISE;
							DPIT_PARTICLEFIRE_NOISE_NUTOUS;
							DPIT_PARTICLEFIRE_NOISE_OBER;
							DPIT_PARTICLEFIRE_NOISE_PEZO;
							DPIT_PARTICLEFIRE_NOISE_POXO;
							DPIT_PARTICLEFIRE_NOISE_RANDOM;
							DPIT_PARTICLEFIRE_NOISE_SEMA;
							DPIT_PARTICLEFIRE_NOISE_STUPL;
							DPIT_PARTICLEFIRE_NOISE_TURBULENCE;
							DPIT_PARTICLEFIRE_NOISE_VL_NOISE;
							DPIT_PARTICLEFIRE_NOISE_WAVY_TURB;
							DPIT_PARTICLEFIRE_NOISE_SEPARATOR;
							DPIT_PARTICLEFIRE_NOISE_CELL_VORONOI;
							DPIT_PARTICLEFIRE_NOISE_DISPL_VORONOI;
							DPIT_PARTICLEFIRE_NOISE_SPARSE_CONV;
							DPIT_PARTICLEFIRE_NOISE_VORONOI_1;
							DPIT_PARTICLEFIRE_NOISE_VORONOI_2;
							DPIT_PARTICLEFIRE_NOISE_VORONOI_3;
							DPIT_PARTICLEFIRE_NOISE_ZADA;
							DPIT_PARTICLEFIRE_NOISE_FIRE;
							DPIT_PARTICLEFIRE_NOISE_ELECTRIC;
							DPIT_PARTICLEFIRE_NOISE_GASOUS;
						}
					}
					REAL DPIT_PARTICLEFIRE_NOISE_DENSITY {MIN 0; MAX 1000; UNIT PERCENT;}	
					GRADIENT DPIT_PARTICLEFIRE_GRADIENT {ANIM ON; ALPHA;}
					REAL DPIT_PARTICLEFIRE_NOISE_SCAGBL {MIN 0; UNIT PERCENT;}
					VECTOR DPIT_PARTICLEFIRE_NOISE_SCALE {MIN 0 0 0; UNIT PERCENT;}
					LONG DPIT_PARTICLEFIRE_NOISE_OCTAVES {MIN 0; MAX 20;}
					REAL DPIT_PARTICLEFIRE_NOISE_SPEED {STEP 0.1;}
					BOOL DPIT_PARTICLEFIRE_NOISE_ABS {}
				}
			}
		}
		GROUP DPIT_HEAT_OPTICAL_SID
		{
			DEFAULT 1;
			LONG  DPIT_HEAT_FIRETYPE 
			{
				CYCLE
				{
				DPIT_HEAT_FIRETYPE_PHYSICAL;
				DPIT_HEAT_FIRETYPE_ARTISTIC;
				}
			}
			LONG  DPIT_HEAT_INTEGRATION
			{
				CYCLE
				{
					DPIT_HEAT_INTEGRATION_ABSORPTION;
					DPIT_HEAT_INTEGRATION_ALBEDO;
					DPIT_HEAT_INTEGRATION_CUSTOM;
				}
			}
			LONG  DPIT_HEAT_INTEGRATION_MODE
			{
				CYCLE
				{
					DPIT_HEAT_INTEGRATION_MODE_ADD;
					DPIT_HEAT_INTEGRATION_MODE_MULTIPLY;
				}
			}
			REAL	DPIT_HEAT_SOOT {MIN 0; MAX 1.0; STEP 0.01; }	
			SEPARATOR{LINE;}
			GROUP
			{
				COLUMNS 2;
				REAL  DPIT_HEAT_OPACITY {MIN 0; MAX 100; UNIT PERCENT; }
				LONG  DPIT_HEAT_CHANNEL
				{
					CYCLE
					{
						DPIT_HEAT_CHANNEL_HEAT;
						DPIT_HEAT_CHANNEL_BURN;
						DPIT_HEAT_CHANNEL_SMOKE;
					}
				}
				REAL  DPIT_HEAT_DECAY {MIN 0; MAX 1000; MAXSLIDER 100; UNIT PERCENT; }
				LONG  DPIT_HEAT_CHANNEL_DECAY
				{
					CYCLE
					{
						DPIT_HEAT_CHANNEL_DECAY_HEAT;
						DPIT_HEAT_CHANNEL_DECAY_BURN;
						DPIT_HEAT_CHANNEL_DECAY_SMOKE;
					}
				}
				REAL  DPIT_HEAT_ALBEDO {MIN 0; MAX 10; MAXSLIDER 1; STEP 0.01; }
				LONG  DPIT_HEAT_CHANNEL_ALBEDO
				{
					CYCLE
					{
						DPIT_HEAT_CHANNEL_ALBEDO_HEAT;
						DPIT_HEAT_CHANNEL_ALBEDO_BURN;
						DPIT_HEAT_CHANNEL_ALBEDO_SMOKE;
					}
				}
			}
			SEPARATOR{LINE;}
			LONG  DPIT_HEAT_PHASE
			{
				HIDDEN;
				CYCLE
				{
					SMOKE_HEATPHASE_NONE;
					SMOKE_HEATPHASE_GREENSTEIN;
					SMOKE_HEATPHASE_RAYLEIGH;
					SMOKE_HEATPHASE_MIE;
					SMOKE_HEATPHASE_HAZY;
					SMOKE_HEATPHASE_MURKY;
					SMOKE_HEATPHASE_SCHLICK;
				}
			}
			REAL DPIT_HEAT_GREENSTEIN_G {HIDDEN; MIN -100; MAX 100; UNIT PERCENT;}
		}
		GROUP DPIT_HEAT_ALPHA_G
		{
			BOOL DPIT_HEAT_USENOISE {}
			
			GROUP
			{
			
				LAYOUTGROUP; COLUMNS 2;
				GROUP
				{
					BITMAPBUTTON DPIT_HEAT_NOISE_PREVIEW {BORDER;}
				}
				GROUP
				{
					
					LONG DPIT_HEAT_NOISE
					{
					     CYCLE
					      {
					      
							DPIT_HEAT_NOISE_BOX_NOISE;
							DPIT_HEAT_NOISE_BLIST_TURB;
							DPIT_HEAT_NOISE_BUYA;
							DPIT_HEAT_NOISE_CELL_NOISE;
							DPIT_HEAT_NOISE_CRANAL;
							DPIT_HEAT_NOISE_DENTS;
							DPIT_HEAT_NOISE_DISPL_TURB;
							DPIT_HEAT_NOISE_FBM;
							DPIT_HEAT_NOISE_HAMA;
							DPIT_HEAT_NOISE_LUKA;
							DPIT_HEAT_NOISE_MOD_NOISE;
							DPIT_HEAT_NOISE_NAKI;
							DPIT_HEAT_NOISE_NOISE;
							DPIT_HEAT_NOISE_NUTOUS;
							DPIT_HEAT_NOISE_OBER;
							DPIT_HEAT_NOISE_PEZO;
							DPIT_HEAT_NOISE_POXO;
							DPIT_HEAT_NOISE_RANDOM;
							DPIT_HEAT_NOISE_SEMA;
							DPIT_HEAT_NOISE_STUPL;
							DPIT_HEAT_NOISE_TURBULENCE;
							DPIT_HEAT_NOISE_VL_NOISE;
							DPIT_HEAT_NOISE_WAVY_TURB;
							DPIT_HEAT_NOISE_SEPARATOR;
							DPIT_HEAT_NOISE_CELL_VORONOI;
							DPIT_HEAT_NOISE_DISPL_VORONOI;
							DPIT_HEAT_NOISE_SPARSE_CONV;
							DPIT_HEAT_NOISE_VORONOI_1;
							DPIT_HEAT_NOISE_VORONOI_2;
							DPIT_HEAT_NOISE_VORONOI_3;
							DPIT_HEAT_NOISE_ZADA;
							DPIT_HEAT_NOISE_FIRE;
							DPIT_HEAT_NOISE_ELECTRIC;
							DPIT_HEAT_NOISE_GASOUS;
						}
					}
					LONG DPIT_HEAT_NOISE_BASE
					{
						CYCLE
						{
							DPIT_HEAT_NOISE_BASE_WORLD;
							DPIT_HEAT_NOISE_BASE_FLOW;
						}
					}
					LONG DPIT_HEAT_NOISE_DENSITY_BASE
					{
						CYCLE
						{
							DPIT_HEAT_NOISE_DENSITY_BASE_CUSTOM;
							DPIT_HEAT_NOISE_DENSITY_BASE_MAGNITUDE;
							DPIT_HEAT_NOISE_DENSITY_BASE_SMOKE;
							DPIT_HEAT_NOISE_DENSITY_BASE_HEAT;
							DPIT_HEAT_NOISE_DENSITY_BASE_FIRE;
							DPIT_HEAT_NOISE_DENSITY_BASE_VORTICITY;
						}
					}
					REAL DPIT_HEAT_NOISE_DENSITY_BASE_FIELD {MIN 0.001; }
					REAL DPIT_HEAT_NOISE_DENSITY {MIN 0; MAX 1000; UNIT PERCENT;}
				}
			}			
			SEPARATOR{LINE;}
			GRADIENT DPIT_HEAT_NOISE_GRADIENT {ALPHA; ANIM ON;}

			GROUP DPIT_HEAT_NOISE_SID
			{
				REAL DPIT_HEAT_NOISE_SCAGBL {MIN 0.001; UNIT PERCENT;}
				VECTOR DPIT_HEAT_NOISE_SCALE {MIN 0.001 0.001 0.001; UNIT PERCENT;}
				LONG DPIT_HEAT_NOISE_OCTAVES {MIN 0; MAX 20;}
				REAL DPIT_HEAT_NOISE_SPEED {STEP 0.1;}
				BOOL DPIT_HEAT_NOISE_ABS {}
			}
		}
	}
	
	
	GROUP DPIT_SMOKE_POSTWORK_G
	{		
		BOOL  DPIT_SMOKE_PREMULTIPLY {}
		REAL	DPIT_SMOKE_LUMINANCE_INTENS {MIN 0; MAX 1000; MINSLIDER 0; MAXSLIDER 100; UNIT PERCENT; CUSTOMGUI REALSLIDER;}
		GRADIENT DPIT_SMOKE_LUMINANCE_GRADIENT {COLOR; ANIM ON;}

		SEPARATOR {LINE;}
		
		REAL	DPIT_SMOKE_BRIGHTNESS {MIN 0; MAX 1000; MINSLIDER 0; MAXSLIDER 200; UNIT PERCENT; CUSTOMGUI REALSLIDER;}
		REAL	DPIT_SMOKE_CONTRAST {MIN 0; MAX 1000; MINSLIDER 0; MAXSLIDER 100; UNIT PERCENT; CUSTOMGUI REALSLIDER;}
		REAL	DPIT_SMOKE_SATURATION {MIN 0; MAX 1000; MINSLIDER 0; MAXSLIDER 200; UNIT PERCENT; CUSTOMGUI REALSLIDER;}

		GROUP DPIT_SMOKE_POSTWORK_MP_SID
		{
			COLUMNS 2;
			BOOL DPIT_SMOKE_MP_DIFFUSE {}
			BOOL DPIT_SMOKE_MP_LUMINANCE {}
			BOOL DPIT_SMOKE_MP_ALPHA {}
			BOOL DPIT_SMOKE_MP_DEPTH {}
			BOOL DPIT_SMOKE_MP_SHADOWS {}
			BOOL DPIT_SMOKE_MP_SMOKE {}
			BOOL DPIT_SMOKE_MP_FIRE {}
			BOOL DPIT_SMOKE_MP_MOTION {}
			BOOL DPIT_SMOKE_MP_MS {}
			BOOL DPIT_SMOKE_MP_HEAT {}
			BOOL DPIT_SMOKE_MP_FIRELIGHT {}
			BOOL DPIT_SMOKE_MP_SCATTERDEPTH {}
		}
	}
	GROUP DPIT_SMOKE_DISPLAY_TAB
	{
		BOOL DPIT_SMOKE_USETEXTURE {}
		LONG DPIT_SMOKE_SLICES {MIN 1; }
		BOOL DPIT_SMOKE_SIZEOFSOLVER {HIDDEN;}
		GROUP
		{
			
			PARENTID DPIT_SMOKE_SIZEOFSOLVER;
			COLUMNS 2;
			REAL DPIT_SMOKE_DISPLAY_SUBX {MIN 2;HIDDEN;}
			REAL DPIT_SMOKE_DISPLAY_SUBY {MIN 2;HIDDEN;}
		}
		//REAL DPIT_SMOKE_MAXDENSITY {MIN 0.1;}
		BOOL DPIT_SMOKE_DISPLAY_DENSGRAD {}
		BOOL DPIT_SMOKE_DISPLAY_COLORGRAD {}
		BOOL DPIT_SMOKE_CALCLIGHTING {}

		SEPARATOR{LINE;}

		BOOL DPIT_SMOKE_SHOWNOISE {}
		BOOL DPIT_SMOKE_SHOWNOISEDENSITY {HIDDEN;}
		BOOL DPIT_SMOKE_SHOWNOISEDISTRIBUTION {}
	}
}